﻿using log4net;
using Microsoft.Xrm.Sdk;
using System.Threading.Tasks;
using VA.PPMS.Context.Interface;
using VA.PPMS.IWS.ProviderAgreementService.Interface;

namespace VA.PPMS.IWS.ProviderAgreementService
{
    public class ProviderAgreementService : IProviderAgreementService
    {
        private readonly ILog _logger;
        private readonly IPpmsContextHelper _ppmsContextHelper;
        
        public ProviderAgreementService(ILog logger, IPpmsContextHelper ppmsContextHelper)
        {
            _logger = logger;
            _ppmsContextHelper = ppmsContextHelper;
        }

        public async Task ProcessData()
        {
            //_logger.Info("************** Provider Agreement Service ****************************");
            await FireActivityAction();
            
        }
        private async Task FireActivityAction()
        {
            using (var proxy = await _ppmsContextHelper.GetOrganizationServiceProxyAsync())
            {
                proxy.Execute(
                    new OrganizationRequest
                    {
                        RequestName = "ppms_ProviderAgreementExpiration",
                    }
                );
            }
            //_logger.Info("************** Provider Agreement Service After Execute ****************************");
        }
    }
}